<?php

include('../common/parseargs.php');
include('../common/basicargcheck.php');

# Parameters for creating User

####	Mandatory parameters start	####

# This is the login name of the user #
$newUser->userName="userName";

# The password required to login #
$newUser->password="password";

# The type of user being created. This parameter defines the accessibility the user has. #
# "userType" can be of type: SUPER_USER, POWER_USER, SUB_USER #
# For more information look at UserTypes in package User #
$newUser->userType="SUPER_USER";

####	Mandatory parameters end	####




####	Optional parameters start	####

# a vaild email address if needed with a string length less than 255 characters
#$newUser->emailAddress="youname@yourcompany.com";

# this is a list of group UUIDs. This is the group of which the new user is a part off. 
#$newUser->groupIDs = array("");

# This parameter is only vaild for sub users who might need power user to manage them. An administrator is a power user, Sub users or Super users cannot be administrators.
#$newUser->administratorIDs= array("");

# This is a list of UUID of sub users that the user being created can manage. You can get the UUID of Users by calling "getUsers()" [ to  get complete users information ] or "getUserIDs()" [ to get only the UUID without any details ]
#$newUser->subUserIDs = array("");

####	Optional parameters end		####


try{
	$client = new soapclient("https://$HOST:$PORT/User?wsdl",
		array('login'=>"$USER", 
		'password'=>"$PASS",
		'trace'=>1
		 )
	);

	$client->createUser(array('user'=>$newUser));

	echo "Successfully executed createUser\n";

	exit(0);

} 
catch (SoapFault $exception)
{
	echo $exception;
	exit(1);
}
?> 
