#!/bin/bash 

# update conf                                                                      
PREVIOUS=server.conf.save                                        
MERGED=server.conf.merged                                            
CURRENT=server.conf                                                  
INSTALL=server.conf.install                                          

if [ -f $PREVIOUS ]; then
	cat $PREVIOUS | sed '/^\s*$/d' | grep -v 'additional' > $MERGED 
	
	echo "" >> $MERGED                                                             
	echo "" >> $MERGED                                                             

	count=1
	for i in `cat $PREVIOUS | sed '/^\s*$/d' | grep '^additional' | grep -v 'Djava.class.path' | sed s/^additional\.[0-9]*=//g`; do
	
		if [[ $i =~ "UseGCOverheadLimit" || $i =~ "DisableExplicitGC" ]]
		then
			continue
		fi
	
		echo "additional.$count=$i" >> $MERGED
		let count="$count+1"
		
		if [[ $i =~ "UseCodeCacheFlushing" ]]
		then
			let HAS_CODE_CACHE_FLUSHING=1
		fi 
		
		if [[ $i =~ "ReservedCodeCacheSize" ]]
		then
			let HAS_RESERVED_CODE_CACHE_SIZE=1
		fi

		if [[ $i =~ "Xss" ]]
		then
			let HAS_STACK_SIZE=1
		fi
	done
	
	if [ -z "$HAS_CODE_CACHE_FLUSHING" ]
	then
		echo "additional.$count=-XX:+UseCodeCacheFlushing" >> $MERGED
		let count="$count+1"
	fi

	if [ -z "$HAS_RESERVED_CODE_CACHE_SIZE" ]
	then
		echo "additional.$count=-XX:ReservedCodeCacheSize=1024m" >> $MERGED
		let count="$count+1"
	fi

	if [ -z "$HAS_STACK_SIZE" ]
	then
		echo "additional.$count=-Xss2048k" >> $MERGED
		let count="$count+1"
	fi
		
	cat $CURRENT | sed '/^\s*$/d' | grep '^additional' | grep  'Djava.class.path' | sed s/^additional\.[0-9]*=/additional.$count=/g >> $MERGED

	echo "" >> $MERGED
	echo "" >> $MERGED
	
	mv $CURRENT $INSTALL
	mv $MERGED $CURRENT                                                            

fi   

