#!/bin/bash
#
# Copyright 2011 Idera, Inc.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


get_ve_fs_root(){

	ve_id_arg="$1"
	ve_private_path="$2"
	ve_root_path="$3"

	if [ -d "$ve_private_path/fs/root/etc" ]; then
		echo "$ve_id_arg:veprivatefsroot:$ve_private_path/fs/root"
	elif [ -d "$ve_private_path/fs/etc" ]; then
		echo "$ve_id_arg:veprivatefsroot:$ve_private_path/fs"
	elif [ -d "$ve_private_path/etc" ]; then
		echo "$ve_id_arg:veprivatefsroot:$ve_private_path/"
	elif [ -d "$ve_root_path/etc" ]; then
		echo "$ve_id_arg:veprivatefsroot:$ve_root_path/"
	fi
}


# extract vz version
# if vz version < 7; use the pkg lib thingy to get VE_PRIVATE and VE_ROOT
# else extract VE_PRIVATE and VE_ROOT from container conf


VZ_VERSION_STRING=`vzctl --version`
VZ_MAJOR_VERSION=$(echo $VZ_VERSION_STRING | cut -d '.' -f 2)

# echo "DBG: Vz version: $VZ_MAJOR_VERSION"

if [[ $VZ_MAJOR_VERSION != [0-9]* ]]  || [[ $VZ_MAJOR_VERSION -lt 7 ]]; then	# vz version check - 6 and below

	#echo "dbg : vz pkglib: $VZPKGLIB"
	VZPKGLIB=${VZPKGLIB:-/usr/share/vzpkgtools/vzpkglib}
	if [ ! -f $VZPKGLIB ]; then
	        echo "ERROR: Could not find $VZPKGLIB"
	        exit 1
	fi
	. $VZPKGLIB

	read_vz_globals
	for VEID in `vzlist -a -H -o ctid`; do
		if [ $VEID -eq 1 ]; then
			continue
		fi
		read_ve_config $VEID
		get_ve_fs_root "$VEID" "$VE_PRIVATE" "$VE_ROOT" 
	done

else	# vz version check - 7 and above

	VZ7CONF_DIR=/etc/vz/conf
	#echo "dbg : vz conf dir: $VZ7CONF_DIR"
	if [ ! -d $VZ7CONF_DIR ]; then
		echo "ERROR: Could not find $VZ7CONF_DIR"
		exit 1
	fi
	
	for VEID in `vzlist -a -H -o ctid`; do
		
		VECONF_FILE=$VZ7CONF_DIR/$VEID.conf
		if [ ! -f $VECONF_FILE ]; then
			echo "ERROR: Could not find $VECONF_FILE"
			exit 1
		fi

		source $VECONF_FILE	
		get_ve_fs_root "$VEID" "$VE_PRIVATE" "$VE_ROOT"
	
	done

fi 		# vz version check - end

