#!/usr/bin/perl
#
# Copyright 2011 Idera, Inc.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package BuagentAuth;

use warnings;
use strict;


sub auth {

	my $user = shift;
	my $pass = shift;
	my $cpanelSession = shift;
	my $cpanelSessionStartTime = shift;
	my $cpanelSessionDir = shift;
	
	my $passwdfile = shift || '/etc/passwd';
	my $shadowfile = shift || '/etc/shadow';
	
	my $auth_ok = 0;

	# If the username is not defined or is empty, go to 'finish' and return the default auth_ok flag value(which is 0)
	# i.e authentication failed when the usernaame is empty or not defined
	if (!defined($user) || $user eq "") { goto finish; }

	my $homedir;
	my $uid;
	my $gid;

	my $passwd;
	open($passwd, '<', $passwdfile) || goto finish;
	while(<$passwd>) {
		my @fields = split /:/;
		if ($fields[0] eq $user) {
			$homedir = $fields[5];
			$uid = $fields[2];
			$gid = $fields[3];
			last;
		}
	}
	close($passwd);

	my $shadow;
	my $cryptpass;
	open($shadow, '<', $shadowfile) || goto finish;
	while(<$shadow>) {
		my @fields = split /:/;
		if ($fields[0] eq $user) {
			$cryptpass = $fields[1];
			last;
		}
	}
	close($shadow);
	if (defined ($cryptpass) && $cryptpass ne "" && crypt($pass, $cryptpass) eq $cryptpass) {
		$auth_ok = 1;
	}

	my $sessionFile = $cpanelSessionDir."\/sess_".$cpanelSession;
	# Here we are setting the time out to be of 10 seconds, cpanelSessionStartTime is in UNIX timestamp(in seconds) to which we
	# add 10 seconds and check against the currentTime which is also in UNIX timestamp(in seconds) by default
	my $timeout = $cpanelSessionStartTime + 10;
	my $currentTime = time();

	# If the password is not defned or is empty, that means this is an WHM Login; so check if the session file exists
	# if yes; then check the session timeout validity, and accordingly set the auth_ok flag.
	if(!defined($pass) || $pass eq "" ){
		if(-e $sessionFile && $currentTime lt $timeout){
			print "User authenticated successfully using session\n";
			$auth_ok = 1;	
		}else{
			print "Session timeout! time taken for authentication exceeded 10 seconds"
		}
	}
	# Remove the session file irrespective of type of login(WHm login or Cpanel Direct login)
	unlink $sessionFile;

	if (!defined($homedir) || $homedir eq "" || !defined($uid) || $uid !~ /^\d+$/ || !defined($gid) || $gid !~ /^\d+$/) {
		$auth_ok = 0;
	}

finish:

	my %result;
	$result{auth_ok} = $auth_ok;
	if ($auth_ok == 1) {
		$result{uid}=$uid;
		$result{gid}=$gid;
		$result{homedir}=$homedir;
	}
	return \%result;
}

1;
