#!/bin/sh

# Check that there's an mdadm utility available
mdadm --version > /dev/null 2>&1
if [ $? -eq 127 ]; then exit 0; fi;

# Loop around each device in the output...
# mdadm --detail -scan outputs lines in the format:
# ARRAY ${DEVICE_PATH} ...
for DEVICE_PATH in `mdadm --detail --scan | awk '{ print $2 }'`;
do
    # If DEVICE_PATH is a symlink, it will get the target's absolute path.
    # If it is not a symlink, same path will be returned
    DEVICE=`readlink -f $DEVICE_PATH`;

    # mdadm --detail --brief -v $DEVICE gives most of the device details on a single line
    echo -n `mdadm --detail --brief -v $DEVICE`;

    # mdadm --detail -vv $DEVICE gives the full output in a multi-line format
    FULL_MD_OUTPUT=`mdadm --detail -vv $DEVICE`;

    # Parse the chunk size
    CHUNK=`echo "$FULL_MD_OUTPUT" | awk '/Chunk Size[ ]*:[ ]*([0-9]+[A-Z])/ { print $4; }' | sed s/K//`;
    if [ "$CHUNK" != "" ]; then echo -n " chunk=$CHUNK"; fi;

    # Parse the layout
    LAYOUT=`echo "$FULL_MD_OUTPUT" | awk '/Layout[ ]*:[ ]*(.+?)$/ { print $3; }'`;
    if [ "$LAYOUT" != "" ]; then echo -n " layout=$LAYOUT"; fi;

	# Parse the failed device count
	FAILED=`echo "$FULL_MD_OUTPUT" | awk '/Failed Devices[ ]*:[ ]*([0-9]+)$/ { print $4; }'`;
	if [ "$FAILED" != "" ]; then echo -n " failed-devices=$FAILED"; fi;

	# Parse the failed device count
	WORKING=`echo "$FULL_MD_OUTPUT" | awk '/Working Devices[ ]*:[ ]*([0-9]+)$/ { print $4; }'`;
	if [ "$WORKING" != "" ]; then echo -n " working-devices=$WORKING"; fi;

    # Print a newline
    echo;

done;
