#!/usr/bin/perl
#
# Copyright (c) 2020 Continuum LLC.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package BuagentPleskAuth;

use strict;
use DBI;
use FindBin;
use lib "$FindBin::RealBin/";
use BuagentAuth;


sub get_all_arrayref {
	my $dbh = shift;
	my $statement = shift;
	my $sth = $dbh->prepare($statement) or die $dbh->errstr;
	$sth->execute(@_) or die $dbh->errstr;
	$sth->fetchall_arrayref;
}

sub get_DB_list {
	my $dbh = shift;
	my $statement = q{SELECT t1.login, t4.name from sys_users AS t1, hosting AS t2, domains AS t3, data_bases AS t4 WHERE t1.id = t2.sys_user_id AND t2.dom_id = t3.id AND t4.dom_id = t2.dom_id;};
	my $sth = $dbh->prepare($statement) or die $dbh->errstr;
	$sth->execute(@_) or die $dbh->errstr;
	$sth->fetchall_arrayref();	
}

sub get_psa_conf {
	my %psa_conf;
	open(my $conf_file, '<', '/etc/psa/psa.conf') || die("could not open psa conf");
	while(<$conf_file>) {
		chomp;
		s/#.*//;
		my ($name, $value) = split(/\s/, $_, 2);
		$psa_conf{$name} = $value;
	}
	close($conf_file);
	return \%psa_conf;
}

#main

open(PASS, '/etc/psa/.psa.shadow');
my $pass = <PASS>;
$pass =~ s/(?:\n|\r)+?$//;
close(PASS);

my $dbh = DBI->connect('DBI:mysql:psa', 'admin', $pass) or die "Could not connect to database";

my $psa_conf_ref = get_psa_conf();

my $db_ref = get_DB_list($dbh);

foreach (@$db_ref) {
	my ($user, $dbname) = @$_;
	
	print $user . ":database name:" . $dbname . "\n";
}
