#!/usr/bin/perl
#
# Copyright 2006 Righteous Software Inc.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

use warnings;
use strict;

use FindBin;
use lib "$FindBin::RealBin/";
use BuagentAuth;
my $DOMAINMAP = "/etc/virtualhosting/mappings/domainmap";

my $user = <>;
chomp($user);
my $pass = <>;
chomp($pass);
my $domain;
my $auth_ok = 0;
my @dirs;

$user =~ s/:\s//g;
($user, $domain) = split('@', $user, 2);

if(!defined($user) || !defined($domain)) { goto end; }

my $site;
open(my $dm, '<', $DOMAINMAP);
while(<$dm>) {
        chomp;
        if(/^\Q$domain\E\s*=\s*(.*)$/) {
                $site = $1;
        }
}
close($dm);
if (!defined($site)) { goto end; }

my $fst = "/home/virtual/$site/fst";
my $auth_ref = BuagentAuth::auth($user, $pass, $fst . "/etc/passwd", $fst . "/etc/shadow");
if ($auth_ref->{auth_ok} == 0) { goto end; }

my $homedir = (getpwuid($auth_ref->{uid}))[7];
if (defined($homedir) && $homedir eq $fst) {
        $auth_ok = 1;
        push @dirs, "dir:domain file system:$homedir";
}

end:
print "auth_ok:$auth_ok\n";
if ($auth_ok) {
	print "uid:" . $auth_ref->{uid} . "\n";
	print "gid:" . $auth_ref->{gid} . "\n";
	print join("\n", @dirs) . "\n";
}

