#!/usr/bin/env perl
#
# Copyright (c) 2020 Continuum LLC.
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

use warnings;
use strict;


sub get_DB_list{
        my($username,$pass,$connectionString)=@_;
        require DBI;
        my $dbh = DBI->connect($connectionString, 'da_admin', $pass) or die "Could not connect to Database";
        my $statement = q{Select Db from db where User=?};
        my $sth = $dbh->prepare($statement) or die $dbh->errstr;
        $sth->execute($username) or die $dbh->errstr;
        $sth->fetchall_arrayref();
}

#main
my $user = $ARGV[0];
my $db_list;
my $socketPath ="";
my $passFile ='/usr/local/directadmin/conf/mysql.conf';
my $password;
open(PASSWORD, '<', $passFile) or die $!;

while(<PASSWORD>){
        if($_=~m/passwd\=/){
                $password = $';
        }
}

close(PASSWORD);
my $pass= $password;
$pass =~ s/(?:\n|\r)+?$//;

my $osFile ='/etc/os-release';
my $osVersion;

open(OS_FILE, '<', $osFile) or die $!;

while(<OS_FILE>){
        if($_=~m/rhel/){
                $osVersion = "redhat";
                last;
        }elsif($_=~m/debian/){
                $osVersion = "debian";
                last;
        }
}

close(OS_FILE);

#check if the perl db modules are installed if not then install the modules
if("redhat" eq $osVersion){
        my $dbi_exists =`yum list | grep perl-DBI`;
        if($dbi_exists eq ""){
                 system ("yum -y install perl-DBI");
        }
        my $dbd_exists =`yum list | grep perl-DBD-MySQL`;
        if($dbd_exists eq ""){
                 system ("yum -y install perl-DBD-mysql");
        }
        my $connectionString = "DBI:mysql:mysql";
        $db_list = get_DB_list($user,$pass,$connectionString);
}
elsif("debian" eq $osVersion){
        my $dbi_exists =`dpkg --list | grep libdbi-perl`;
        if($dbi_exists eq ""){
                system ("apt-get install libdbi-perl -y");
        }
        my $dbd_exists =`dpkg --list | grep libdbd-mysql-perl`;
        if($dbd_exists eq ""){
                system ("apt-get install libdbd-mysql-perl -y");
        }
        
        #Get the socket path from my.cnf
        #This path is required only in debian distribution
        #Incase of default mysql installation this path is specified in "/etc/my.cnf"

        my $socketFilePath ='/etc/my.cnf';
        my $path;
        open(PATH, '<', $socketFilePath) or die $!;

                while(<PATH>){
                        if($_=~m/socket\=/){
                                $path = $';
                        }
                }
        close(PATH);

        $socketPath= $path;
        $socketPath =~ s/(?:\n|\r)+?$//;
        my $connectionString = "DBI:mysql:mysql;mysql_socket=".$socketPath;
        $db_list = get_DB_list($user,$pass,$connectionString);
}
else{
        system ("yum -y install perl-DBD-mysql");
        my $connectionString = "DBI:mysql:mysql";
        $db_list = get_DB_list($user,$pass,$connectionString);
}

#print list of dbs
foreach (@$db_list){
        my($dbname) = @$_;

        print "DBName:" . $dbname ."\n";
}

